/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipch;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

public class OipchHPPackageReader {
    private OipchHPPackageReader() {
    }

    static Collection readPackageDetails(String sFile) throws IOException {
        String currentLine;
        BufferedReader reader = new BufferedReader(new FileReader(sFile));
        ArrayList<String> oElements = new ArrayList<String>();
        Object oElement = null;
        while ((currentLine = reader.readLine()) != null) {
            String version;
            StringTokenizer st = new StringTokenizer(currentLine);
            if (st.countTokens() < 3) continue;
            String name = st.nextToken();
            if (name.startsWith("#")) {
                name = st.nextToken();
            }
            if (!OipchHPPackageReader.isVersionOK(version = st.nextToken())) continue;
            oElements.add(name + ":" + version);
        }
        reader.close();
        return oElements;
    }

    static boolean isVersionOK(String vers) {
        boolean rv = true;
        if (vers.indexOf("~") >= 0 || vers.indexOf("_") >= 0 || vers.indexOf("-") >= 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(vers, ".");
        if (st.countTokens() < 1) {
            rv = false;
        }
        if (st.countTokens() == 1) {
            String token = st.nextToken();
            try {
                int dummy = Integer.parseInt(token);
            }
            catch (NumberFormatException e) {
                rv = false;
            }
        } else {
            st.nextToken();
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                try {
                    int dummy = Integer.parseInt(token);
                }
                catch (NumberFormatException e) {
                    rv = false;
                }
            }
        }
        return rv;
    }
}

